// Career Consultations Website - Version 4 (HTML/CSS/JS) - Minimal Design

const goals = [
  { 
    id: 'resume', 
    name: 'Резюме', 
    icon: 'icons/icon-file.svg',
    color: '#FF6B6B',
    description: 'Создание и оптимизация резюме',
    duration: '60 минут',
    result: 'Готовое резюме',
    steps: ['Анализ', 'Структура', 'Оптимизация']
  },
  { 
    id: 'interview', 
    name: 'Собеседование', 
    icon: 'icons/icon-users.svg',
    color: '#FFA07A',
    description: 'Подготовка к собеседованию',
    duration: '90 минут',
    result: 'Готовность к интервью',
    steps: ['Подготовка', 'Практика', 'Стратегия']
  },
  { 
    id: 'career-change', 
    name: 'Смена профессии', 
    icon: 'icons/icon-target.svg',
    color: '#FFB6C1',
    description: 'План перехода в новую сферу',
    duration: '120 минут',
    result: 'План действий',
    steps: ['Анализ навыков', 'Обучение', 'Переход']
  },
  { 
    id: 'coaching', 
    name: 'Коучинг', 
    icon: 'icons/icon-trending.svg',
    color: '#FF8787',
    description: 'Долгосрочное карьерное развитие',
    duration: '90 минут',
    result: 'Стратегия развития',
    steps: ['Цели', 'Навыки', 'Продвижение']
  }
]

const consultants = [
  { name: 'Елена Смирнова', experience: '12 лет', rating: 5, specialty: 'Резюме, Собеседование', clients: '2500+', success: '98%' },
  { name: 'Дмитрий Петров', experience: '15 лет', rating: 5, specialty: 'Собеседование, Коучинг', clients: '3200+', success: '96%' },
  { name: 'Анна Козлова', experience: '10 лет', rating: 5, specialty: 'Смена профессии, Коучинг', clients: '1800+', success: '94%' },
  { name: 'Михаил Волков', experience: '8 лет', rating: 5, specialty: 'Резюме, Карьерный рост', clients: '2100+', success: '97%' }
]

let currentSlide = 0
let slides = []
let dots = []
let slideInterval

function initPage() {
  const currentPage = window.location.pathname.includes('book.html') ? 'book' : 'index'
  
  if (currentPage === 'book') {
    initBookPage()
  } else {
    initIndexPage()
  }
  
  initSlider()
}

function initIndexPage() {
  loadSessions()
  updateStats()
  
  setInterval(() => {
    loadSessions()
    updateStats()
  }, 500)
}

function loadSessions() {
  const saved = localStorage.getItem('careerSessions')
  let sessions = []
  
  if (saved) {
    try {
      sessions = JSON.parse(saved)
    } catch (e) {
      sessions = []
    }
  } else {
    sessions = [
      {
        id: 1,
        consultant: 'Елена Смирнова',
        topic: 'Подготовка резюме',
        result: 'Резюме обновлено, получено 3 приглашения на собеседование',
        review: 'Отличная консультация, помогла структурировать опыт',
        rating: 5,
        date: '2025-03-25'
      },
      {
        id: 2,
        consultant: 'Дмитрий Петров',
        topic: 'Собеседование',
        result: 'Успешно прошел собеседование, получил оффер',
        review: 'Профессиональная подготовка, все советы пригодились',
        rating: 5,
        date: '2025-03-20'
      },
      {
        id: 3,
        consultant: 'Анна Козлова',
        topic: 'Смена профессии',
        result: 'Определен план перехода в новую сферу',
        review: 'Помогла понять, куда двигаться дальше',
        rating: 4,
        date: '2025-03-15'
      }
    ]
    localStorage.setItem('careerSessions', JSON.stringify(sessions))
  }
  
  const sessionList = document.getElementById('sessionList')
  if (sessionList) {
    if (sessions.length === 0) {
      sessionList.innerHTML = `
        <div class="empty-state-minimal">
          <img src="icons/icon-briefcase.svg" alt="Briefcase" width="64" height="64">
          <h3 class="empty-title">Начните свой карьерный путь</h3>
          <p class="empty-text">Запишитесь на первую консультацию и увидите её здесь</p>
        </div>
      `
    } else {
      sessionList.innerHTML = sessions.map(session => {
        const stars = Array.from({ length: 5 }, (_, i) => 
          `<span style="color: ${i < session.rating ? '#FF6B6B' : '#E0E0E0'}">★</span>`
        ).join('')
        
        const date = new Date(session.date).toLocaleDateString('ru-RU', { 
          day: 'numeric', 
          month: 'long', 
          year: 'numeric' 
        })
        
        return `
          <div class="session-item-minimal">
            <div class="session-header-minimal">
              <div class="session-topic-badge-minimal">${session.topic}</div>
              <div class="session-rating-minimal">${stars}</div>
            </div>
            <div class="session-info-minimal">
              <div class="session-detail-minimal">
                <img src="icons/icon-user.svg" alt="User" width="16" height="16">
                <span>${session.consultant}</span>
              </div>
              <div class="session-detail-minimal">
                <img src="icons/icon-calendar.svg" alt="Calendar" width="16" height="16">
                <span>${date}</span>
              </div>
            </div>
            <div class="session-result-minimal">
              <img src="icons/icon-check.svg" alt="Check" width="16" height="16">
              <span class="result-text">${session.result}</span>
            </div>
            ${session.review ? `
              <div class="session-review-minimal">
                <span style="color: #FFD93D">★</span>
                <span class="review-text">${session.review}</span>
              </div>
            ` : ''}
          </div>
        `
      }).join('')
    }
  }
}

function updateStats() {
  const saved = localStorage.getItem('careerSessions')
  let sessions = []
  
  if (saved) {
    try {
      sessions = JSON.parse(saved)
    } catch (e) {
      sessions = []
    }
  }
  
  const totalSessions = sessions.length
  const averageRating = sessions.length > 0
    ? (sessions.reduce((sum, s) => sum + s.rating, 0) / sessions.length).toFixed(1)
    : 0
  const uniqueConsultants = new Set(sessions.map(s => s.consultant)).size
  const successfulResults = sessions.filter(s => 
    s.result.toLowerCase().includes('успешно') || 
    s.result.toLowerCase().includes('получен')
  ).length
  
  const statsMinimalGrid = document.getElementById('statsMinimalGrid')
  if (statsMinimalGrid) {
    statsMinimalGrid.innerHTML = `
      <div class="stat-minimal-item">
        <div class="stat-minimal-icon" style="background: rgba(255, 107, 107, 0.1);">
          <img src="icons/icon-briefcase.svg" alt="Briefcase" width="32" height="32">
        </div>
        <div class="stat-minimal-content">
          <div class="stat-minimal-value">${totalSessions}</div>
          <div class="stat-minimal-label">Сессий</div>
        </div>
      </div>
      <div class="stat-minimal-item">
        <div class="stat-minimal-icon" style="background: rgba(255, 160, 122, 0.1);">
          <img src="icons/icon-star.svg" alt="Star" width="32" height="32">
        </div>
        <div class="stat-minimal-content">
          <div class="stat-minimal-value">${averageRating}</div>
          <div class="stat-minimal-label">Средняя оценка</div>
        </div>
      </div>
      <div class="stat-minimal-item">
        <div class="stat-minimal-icon" style="background: rgba(255, 182, 193, 0.1);">
          <img src="icons/icon-trending.svg" alt="Trending" width="32" height="32">
        </div>
        <div class="stat-minimal-content">
          <div class="stat-minimal-value">${successfulResults}</div>
          <div class="stat-minimal-label">Успешных результатов</div>
        </div>
      </div>
      <div class="stat-minimal-item">
        <div class="stat-minimal-icon" style="background: rgba(255, 135, 135, 0.1);">
          <img src="icons/icon-user.svg" alt="User" width="32" height="32">
        </div>
        <div class="stat-minimal-content">
          <div class="stat-minimal-value">${uniqueConsultants}</div>
          <div class="stat-minimal-label">Консультантов</div>
        </div>
      </div>
    `
  }
}

function initBookPage() {
  const consultationForm = document.getElementById('consultationForm')
  const goalsMinimalList = document.getElementById('goalsMinimalList')
  const dateInput = document.getElementById('consultationDate')
  const successMessage = document.getElementById('successMessage')
  const consultantGridMinimal = document.getElementById('consultantGridMinimal')
  const submitButton = document.getElementById('submitButton')

  let selectedGoal = null

  if (goalsMinimalList) {
    goalsMinimalList.innerHTML = goals.map(goal => `
      <button type="button" class="goal-minimal-item" data-id="${goal.id}" style="border-left-color: rgba(255, 107, 107, 0.2);">
        <div class="goal-minimal-icon" style="background: rgba(255, 107, 107, 0.1); border-color: rgba(255, 107, 107, 0.2);">
          <img src="${goal.icon}" alt="${goal.name}" width="32" height="32">
        </div>
        <div class="goal-minimal-content">
          <h3 class="goal-minimal-name">${goal.name}</h3>
          <p class="goal-minimal-description">${goal.description}</p>
          <div class="goal-minimal-steps">
            ${goal.steps.map(step => `
              <span class="goal-step-badge">
                <span>⚡</span>
                <span>${step}</span>
              </span>
            `).join('')}
          </div>
          <div class="goal-minimal-meta">
            <span class="goal-meta-item">
              <img src="icons/icon-clock.svg" alt="Clock" width="16" height="16">
              <span>${goal.duration}</span>
            </span>
            <span class="goal-meta-item">
              <img src="icons/icon-check.svg" alt="Check" width="16" height="16">
              <span>${goal.result}</span>
            </span>
          </div>
        </div>
      </button>
    `).join('')

    goalsMinimalList.querySelectorAll('.goal-minimal-item').forEach(item => {
      item.addEventListener('click', () => {
        goalsMinimalList.querySelectorAll('.goal-minimal-item').forEach(i => {
          i.classList.remove('selected')
          i.style.borderLeftColor = 'rgba(255, 107, 107, 0.2)'
          i.style.background = 'white'
          const icon = i.querySelector('.goal-minimal-icon')
          if (icon) {
            icon.style.background = 'rgba(255, 107, 107, 0.1)'
            icon.style.borderColor = 'rgba(255, 107, 107, 0.2)'
          }
        })
        item.classList.add('selected')
        selectedGoal = item.dataset.id
        const goalData = goals.find(g => g.id === selectedGoal)
        if (goalData) {
          item.style.borderLeftColor = goalData.color
          item.style.background = 'rgba(255, 107, 107, 0.04)'
          const icon = item.querySelector('.goal-minimal-icon')
          if (icon) {
            icon.style.background = `${goalData.color}20`
            icon.style.borderColor = goalData.color
          }
        }
        
        if (submitButton) {
          submitButton.disabled = !selectedGoal || !dateInput.value
        }
      })
    })
  }

  if (dateInput) {
    const today = new Date()
    const maxDate = new Date()
    maxDate.setDate(maxDate.getDate() + 90)
    
    dateInput.min = today.toISOString().split('T')[0]
    dateInput.max = maxDate.toISOString().split('T')[0]
    
    dateInput.addEventListener('change', () => {
      if (submitButton) {
        submitButton.disabled = !selectedGoal || !dateInput.value
      }
    })
  }

  if (consultationForm) {
    consultationForm.addEventListener('submit', (e) => {
      e.preventDefault()
      
      if (selectedGoal && dateInput && dateInput.value) {
        const savedSessions = localStorage.getItem('careerSessions')
        const sessions = savedSessions ? JSON.parse(savedSessions) : []
        
        const goalData = goals.find(g => g.id === selectedGoal)
        const randomConsultant = consultants[Math.floor(Math.random() * consultants.length)]
        
        const newSession = {
          id: Date.now(),
          consultant: randomConsultant.name,
          topic: goalData.name,
          result: `Консультация запланирована. Ожидаемый результат: ${goalData.result}`,
          review: '',
          rating: 0,
          date: dateInput.value
        }

        sessions.push(newSession)
        localStorage.setItem('careerSessions', JSON.stringify(sessions))
        
        if (successMessage) {
          successMessage.style.display = 'flex'
          setTimeout(() => {
            window.location.href = 'index.html'
          }, 2000)
        }
      }
    })
  }

  if (consultantGridMinimal) {
    consultantGridMinimal.innerHTML = consultants.map(consultant => {
      const stars = Array.from({ length: 5 }, () => '★').join('')
      return `
        <div class="consultant-card-minimal">
          <div class="consultant-avatar-minimal">
            <img src="icons/icon-user.svg" alt="${consultant.name}" width="48" height="48">
            <div class="consultant-success-badge">
              <span>${consultant.success}</span>
            </div>
          </div>
          <div class="consultant-content-minimal">
            <h3 class="consultant-name-minimal">${consultant.name}</h3>
            <p class="consultant-experience-minimal">${consultant.experience} опыта</p>
            <div class="consultant-rating-minimal">
              ${Array.from({ length: 5 }, () => '<span style="color: #FF6B6B;">★</span>').join('')}
            </div>
            <p class="consultant-specialty-minimal">${consultant.specialty}</p>
            <div class="consultant-stats-minimal">
              <div class="consultant-stat-minimal">
                <img src="icons/icon-users.svg" alt="Users" width="16" height="16">
                <span>${consultant.clients} клиентов</span>
              </div>
              <div class="consultant-stat-minimal">
                <img src="icons/icon-trending.svg" alt="Trending" width="16" height="16">
                <span>${consultant.success} успеха</span>
              </div>
            </div>
          </div>
        </div>
      `
    }).join('')
  }
}

function initSlider() {
  const slider = document.getElementById('slider')
  if (!slider) return

  slides = Array.from(slider.querySelectorAll('.slide'))
  dots = Array.from(slider.querySelectorAll('.dot'))
  const prevBtn = document.getElementById('sliderPrev')
  const nextBtn = document.getElementById('sliderNext')

  if (slides.length === 0) return

  function showSlide(n) {
    slides.forEach(slide => slide.classList.remove('active'))
    dots.forEach(dot => dot.classList.remove('active'))
    
    currentSlide = (n + slides.length) % slides.length
    
    slides[currentSlide].classList.add('active')
    if (dots[currentSlide]) dots[currentSlide].classList.add('active')
  }

  function nextSlide() {
    showSlide(currentSlide + 1)
  }

  function prevSlide() {
    showSlide(currentSlide - 1)
  }

  if (nextBtn) {
    nextBtn.addEventListener('click', () => {
      clearInterval(slideInterval)
      nextSlide()
      startSlider()
    })
  }

  if (prevBtn) {
    prevBtn.addEventListener('click', () => {
      clearInterval(slideInterval)
      prevSlide()
      startSlider()
    })
  }

  dots.forEach((dot, index) => {
    dot.addEventListener('click', () => {
      clearInterval(slideInterval)
      showSlide(index)
      startSlider()
    })
  })

  function startSlider() {
    slideInterval = setInterval(nextSlide, 3000)
  }

  startSlider()
}

document.addEventListener('DOMContentLoaded', initPage)

